package gov.va.vamf.scheduling.direct.domain

import spock.lang.Specification

class CoreSettingsSpec extends Specification {

    def 'CoreSettings#findCoreSettingById(String) should find a setting by id'() {
        when:
        def settings = makeCoreSettings(3)

        then:
        settings.findCoreSettingById(settings[0].id).orElse(null) == settings[0]
        settings.findCoreSettingById(settings[1].id).orElse(null) == settings[1]
        settings.findCoreSettingById(settings[2].id).orElse(null) == settings[2]
    }

    def 'CoreSettings#findCoreSettingById(String) should return an empty Optional when a setting is not found'() {
        expect:
        !settings.findCoreSettingById('nope').isPresent()

        where:
        settings << [makeCoreSettings(0), makeCoreSettings(3)]
    }

    private def makeCoreSettings(count) {
        (1..count).collect { new CoreSetting("id-$it", '', '', 0) } as CoreSettings
    }

}
